"use client";

import { useEffect, useMemo, useState } from "react";
import { useRouter } from "next/navigation";
import CustomDataTable from "../../../dataTable/customDataTable";
import { BookOpenIcon } from "@heroicons/react/24/solid";
import QCReviewModal from "@/app/components/modals/qcReviewModal";
import EDAReviewModal from "@/app/components/modals/edaReviewModal";
import PRReviewModal from "@/app/components/modals/prReviewModal";
import MDReviewModal from "@/app/components/modals/mdReviewModal";
import CEReviewModal from "@/app/components/modals/ceReviewModel";
import { getFCColumns } from "./columnsFC";
import { getFCQCColumns } from "./columnsFCQC";
import { getEDAColumns } from "./columnsEDA";
import { getPRColumns } from "./columnsPR";
import { getMDColumns } from "./columnsMD";
import { getCEColumns } from "./columnsCE";
import { getRCColumns } from "./columnsRC";
export default function BookChaptersList({ initialStageChapters, stagename, status, initialstatus, initialMDstatus,initialCEstatus,userId,editorList }) {
  const [data, setData] = useState(initialStageChapters || []);
  const [cedata, setCEData] = useState(initialCEstatus || []);
  const [loading, setLoading] = useState(true);
  const [QCReviewModalOpen, setQCReviewModalOpen] = useState(false);
  const [EDAReviewModalOpen, setEDAReviewModalOpen] = useState(false);
  const [PRReviewModalOpen, setPRReviewModalOpen] = useState(false);
  const [MDReviewModalOpen, setMDReviewModalOpen] = useState(false);
  const [CEReviewModalOpen, setCEReviewModalOpen] = useState(false);
  const [chapterId, setChapterId] = useState(null);
  const [selectedRow, setSelectedRow] = useState(null);
  const router = useRouter();

  console.log(cedata,"cedata")
  // console.log(data,"data")

  useEffect(() => {
    setData(initialStageChapters || []);
    setLoading(false);
  }, [initialStageChapters]);

  useEffect(() => {
    setCEData(initialCEstatus || []);
    setLoading(false);
  }, [initialCEstatus]);

let columns = [];
  //   const columns = useMemo(() => getBookChapterColumns(router, handleDelete), [router]);
  if(status == "FC"){
    columns = useMemo(() => getFCColumns(router, data), []);
  } if(status == "FCQC"){
    columns = useMemo(() => getFCQCColumns(router, data, setQCReviewModalOpen, setChapterId, userId), [router]);
  } if(status == "EDA"){
    columns = useMemo(() => getEDAColumns(router, data, setEDAReviewModalOpen, setChapterId), []);
  } if(status == "PR"){
    columns = useMemo(() => getPRColumns(router, data, setPRReviewModalOpen, setChapterId), []);
  } 
  if(status == "MD"){
    columns = useMemo(() => getMDColumns(router, data, setMDReviewModalOpen, setChapterId), []);
  } 
  if(status == "RC"){
    columns = useMemo(() => getRCColumns(router, data), []);
  } 
  if(status == "CE"){
    columns = useMemo(() => getCEColumns(router, cedata, setCEReviewModalOpen, setChapterId), []);
  }
  // else if(status == "FCQC"){
  //   columns = useMemo(() => getStageChapterColumns(router, status, setSelectedRow, setQCReviewModalOpen, setChapterId), [router]);
  // }

  return (
    <div className="max-w-full px-4 py-4 mx-auto  rounded-lg  space-y-4">
      <header>
        <div className="flex flex-col justify-start items-start py-4 px-6 bg-white rounded-lg shadow">
          <h2 className="text-2xl font-semibold text-gray-800 leading-tight">Book Chapters Lists</h2>
          <p className="text-gray-500 mt-1 mb-4 text-sm">
            Book based submitted chapters stage wise
          </p>


          <div
            className="group relative inline-flex items-center bg-gradient-to-r from-[#1c2737] via-[#263248] to-[#344155] 
          hover:from-[#222e42] hover:via-[#303d54] hover:to-[#3f4d66] text-white px-3 py-1 rounded-md 
          font-medium text-xs transition-all duration-300 hover:scale-105 hover:shadow-lg 
          overflow-hidden shadow cursor-pointer mb-2"
          >
            <div
              className="absolute inset-0 bg-gradient-to-r from-white/0 via-white/20 to-white/0 
            transform -skew-x-12 -translate-x-full group-hover:translate-x-full 
            transition-transform duration-1000"
            />
            <BookOpenIcon className="relative w-4 h-4 text-white mr-2 opacity-90" />
            <span className="relative tracking-wide">{stagename}</span>
          </div>
        </div>
      </header>

      <CustomDataTable
        columns={columns}
        data={data}
        progressPending={loading}
        defaultSort={{ key: "Book Title", direction: "ascending" }}
        userId ={userId}
      />
      <QCReviewModal
        isOpen={QCReviewModalOpen}
        onClose={() => setQCReviewModalOpen(false)}
        chapterId={chapterId} // ← Pass it here
        initialstatus={initialstatus}
      />
      <EDAReviewModal
        isOpen={EDAReviewModalOpen}
        onClose={() => setEDAReviewModalOpen(false)}
        chapterId={chapterId} // ← Pass it here
        initialstatus={initialstatus}
      />
      <EDAReviewModal
        isOpen={EDAReviewModalOpen}
        onClose={() => setEDAReviewModalOpen(false)}
        chapterId={chapterId} // ← Pass it here
        initialstatus={initialstatus}
      />
      <PRReviewModal
        isOpen={PRReviewModalOpen}
        onClose={() => setPRReviewModalOpen(false)}
        chapterId={chapterId} // ← Pass it here
        initialstatus={initialstatus}
      />
       <MDReviewModal
        isOpen={MDReviewModalOpen}
        onClose={() => setMDReviewModalOpen(false)}
        chapterId={chapterId} // ← Pass it here
        initialstatus={initialMDstatus}
      />
      <CEReviewModal
        isOpen={CEReviewModalOpen}
        onClose={() => setCEReviewModalOpen(false)}
        chapterId={chapterId} // ← Pass it here
        initialstatus={initialCEstatus}
        editorList={editorList}
      />

    </div>
  );
}
